<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class OnepayController extends Controller
{
    //XXX Replace the address corresponding to the corresponding country
    const HOST_URL = 'https://api-pkr.onepay.news'; //Gateway address switching does not require replacement in the formal environment
    const PAY_CODE = 'PKR847';    //Payment code in order

    public $method = 'AES-128-CBC'; //Do not change the AES encryption definition

    //The following three parameters need to be replaced after opening the official merchant account.
    public $password = '23810d0sGgY58bj8'; //AES key
    public $authorizationKey = '8u57Q91u58';  //Merchant Key in the request header
    //
    //Push deposit form
    static public $oderReceive = self::HOST_URL . '/api/v1/order/receive';
    //Push payment order
    static public $oderOut = self::HOST_URL . '/api/v1/order/out';
    //Order Tracking
    static public $oderQuery = self::HOST_URL . '/api/v1/order/query';
    //Merchant balance inquiry
    static public $balanceQuery = self::HOST_URL . '/api/v1/merchant/balance';
    //Self-service callback
    static public $orderNotify = self::HOST_URL .'/api/v1/test/orderNotify';


    /**加密
     * @param array $data
     * @return string
     */
    public function encryptionAes(array $data)
    {
//        $jsonData = json_encode($data,true);
        //Revise
        $jsonData = json_encode($data, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE );
        $aesSecret = bin2hex(openssl_encrypt($jsonData, $this->method,$this->password,  OPENSSL_RAW_DATA, $this->password));
        return $aesSecret;
    }

    /**解密
     * @param $aesSecret
     * @return false|string
     */
    public function decryptAes($aesSecret)
    {
        $str="";
        for($i=0;$i<strlen($aesSecret)-1;$i+=2){
            $str.=chr(hexdec($aesSecret[$i].$aesSecret[$i+1]));
        }
        $jsonData =  openssl_decrypt($str,$this->method,$this->password, OPENSSL_RAW_DATA,$this->password);
        $data = json_decode($jsonData,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        return $data;
    }


    /**获取随机数
     * @param int $length 随机数长度
     * @return string 返回随机数
     */
    public function GetRandStr($length = 8)
    {
        $str='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $len=strlen($str)-1;
        $randStr='';
        for($i=0;$i<$length;$i++){
            $num=mt_rand(0,$len);
            $randStr .= $str[$num];
        }
        return $randStr;
    }

    /**post请求
     * @param string $url
     * @param array $data
     * @return false|string
     */
    public function curlPost($url = '', $data=null)
    {
        $ch = curl_init();//initialization
        curl_setopt($ch, CURLOPT_URL, $url);//Visited URL
        curl_setopt($ch, CURLOPT_POST, true);//The request method is post request
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);//Only get the page content, but do not output it
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);//https Request Do not verify certificate
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);//https Request Do not verify HOST
        $header = [
            'Content-type: application/json;charset=UTF-8',
            'Authorization: '. $this->authorizationKey,
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header); //Simulated header
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));//Request data
        $result = curl_exec($ch);//Execute request
        curl_close($ch);//Close curl and release resources
        return $result;
    }

    /**get ask
     * @param string $url
     * @param array $data
     * @return false|string
     */
    public function curlGet($url = '', $data = array())
    {
        if(!empty($data)) $url = $url .'?'. http_build_query($data);
        $ch = curl_init();//initialization
        curl_setopt($ch, CURLOPT_URL, $url);//Visited URL
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);//Only get the page content, but do not output it
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);//httpsRequest Do not verify certificate
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);//https Request Do not verify HOST
        $result = curl_exec($ch);//Execute request
        curl_close($ch);//Close curl and release resources
        return $result;
    }

    /**post Encrypt data and submit request
     * @param string $url Request address
     * @param array $data   Request data
     * @return false|string     Return data（json string）
     */
    public function postRes($url, array $data)
    {
        $info['data'] = $this->encryptionAes($data);
        $res = $this->curlPost($url, $info);
        return $res;
    }

    /**Decrypt and parse data into arrays;
     * @param string $data 示例:{"data":"50C7CC8B58CEFFD1A824ADE524F4F55DB0DAEE6029ADBB597C1F99D28E1D0779C33B562526F05C6821932DE20B6893ADD6834D3397B7A8E08CC03995A5CDEA7E6B4DF0485466D4C25AEB223DD456DBC0321921FDCA18F9596A1C14B54C5A018CC7C0B922E3DE371626887DA78E539DA81E64EC41938BC3EC5BEBC26A948803E8","merchantNo":"2022011116544301686"}
     * @return false|array
     */
    public function parseData( $data )
    {
        $info = json_decode($data,true );
        $val = $this->decryptAes($info['data']);
        return $val;
    }




    //Call The API
    public function onepay($famount){

        $orderId = date('Ymd').rand(0,9999).rand(0,9999).rand(0,9999);
        $user = Auth::user();
        $amount = (int)$famount * 100;

        ###########Push deposit form
        $data['orderNo'] = $orderId;
        $data['payCode'] = self::PAY_CODE;
        $data['amount'] = $amount;
        $data['notifyUrl'] = '  cash-lngoil-refinery.com ';
        $data['payerName'] = $user->phone;

        $res = $this->postRes(self::$oderReceive, $data);

        $model = new Deposit();
        $model->user_id = $user->id;
        $model->order_id = $orderId;
        $model->amount = $famount;
        $model->final_amount = $famount;
        $model->date = now();
        $model->status = 'pending';
        $model->save();

        return response()->json($res);
    }



    public function onepayWithdraw($withdraw_id){
        $withdraw = Withdrawal::find($withdraw_id);
        $user = User::find($withdraw->user_id);
        $amount = (int)$withdraw->final_amount * 100;
        $payeeType = $user->gateway_method == 'Easypaisa' ? 0 : 2;
        $orderId = $withdraw->oid;

        ###########Push deposit form
        $data['orderNo'] = $orderId;
        $data['payCode'] = self::PAY_CODE;
        $data['amount'] = $amount;
        $data['payeeType'] = $payeeType;
        $data['payeeName'] = $user->name;
        $data['payeeFirstInfo'] = (string)$user->gateway_number;
        $data['payeeSecondInfo'] = $user->gateway_method;
        $data['notifyUrl'] = url('/notify');

        $res = $this->postRes(self::$oderOut, $data);


        return $res;
    }


    public function onepayOrderTrace(){
        $deposits = DB::table('deposits')->where('status', 'pending')->where('user_id', auth()->id())->orderByDesc('id')->get();

        foreach ($deposits as $deposit){
            $data['orderNo'] = $deposit->order_id;
            $data['orderType'] = 1;

            $res = $this->postRes(self::$oderQuery, $data);
            $data = json_decode($res,true);
            $actualData = $data['data'];
            $updateDeposit = Deposit::where('id', $deposit->id)->first();

            if ($data['code'] == 200){
                $actual_amount = $actualData['amount'] / 100;
                if ($actualData['status'] == 2 && $updateDeposit->status == 'pending'){

                    $updateDeposit->amount = $actual_amount;
                    $updateDeposit->final_amount = $actual_amount;
                    $updateDeposit->status = 'approved';

                    if ($updateDeposit->save()){
                        $user = User::where('id', $deposit->user_id)->first();
                        if ($user){
                            $user->balance = $user->balance + $actual_amount;
                            $user->save();

                            $ledger = new UserLedger();
                            $ledger->user_id = $user->id;
                            $ledger->reason = 'recharge_approved';
                            $ledger->perticulation = 'Recharge Approved';
                            $ledger->amount = $actual_amount;
                            $ledger->debit = $actual_amount;
                            $ledger->status = 'pending';
                            $ledger->date = date('y-m-d');
                            $ledger->save();
                        }
                    }
                }

                if ($actualData['status'] == 3){
                    $updateDeposit->status = 'rejected';
                    $updateDeposit->save();
                }
            }
        }

        return true;
    }



    public function onepayWithdrawOrderTrace(){
        $withdraws = DB::table('withdrawals')->where('user_id', auth()->id())->where('status', 'processing')->orderByDesc('id')->get();
        foreach ($withdraws as $withdraw){
            $data['orderNo'] = $withdraw->oid;
            $data['orderType'] = 2;
            $user = User::where('id', $withdraw->user_id)->first();

            $res = $this->postRes(self::$oderQuery, $data);
            $data = json_decode($res,true);
            $actualData = $data['data'];

            $updateWithdraw = Withdrawal::where('id', $withdraw->id)->first();

            if ($data['code'] == 200){
                if ($actualData['status'] == 2){
                    $updateWithdraw->status = 'approved';
                    $updateWithdraw->save();
                }

                if ($actualData['status'] == 3 && $withdraw->status == 'processing'){
                    $updateWithdraw->status = 'rejected';
                    $user->balance = $user->balance + $updateWithdraw->amount;
                    $updateWithdraw->save();
                }
            }
        }
        return true;
    }


    public function onepay_payment_response(Request $request){

        return redirect()->route('user.deposit');
    }

    public function notify(Request $request){


        return redirect()->route('user.deposit');
    }

}
