<div class="tab-bar-wrap tab-bar-wrap-1" style="--ee901710: 20%;">
    <div class="tab-bar">
        <div class="tab-item" onclick="window.location.href='{{route('dashboard')}}'">
            <div data-v-d42c1f6b="" id="tabItem" class="tab-item-inner @if(\Request::route()->getName() == 'dashboard') active @endif">
                <div data-v-d42c1f6b="" class="w-full flex justify-center icon"><img data-v-d42c1f6b=""
                                                                                     class="w-24.78px h-24.28px"
                                                                                     @if(\Request::route()->getName() == 'dashboard')
                                                                                     src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAwCAYAAAC4wJK5AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAfoSURBVHgB7VnNilxFFD6nbpMEEZw8QWbhIm40CIJkk9GlEIxoICDivIAkAV1PJyhux0WWkpmVO5NlUDQTFNxpFPfTeQI74ELJzD1W3arzV3V7OpOMkEUu9PSd+1N1fr7vO6eqAZ4fz8aB8D8cZz6gtY5gAxHOYA8vTQDm8fteh7D50y28B0d8HKkTyfj4tYEE57p4Eggw5O/0oXgt+gW34R+4unMHZ3BEx5E4cfoSrR7fj8YDrMeID8YOhkN2IDmEVJyJ5x0Nny14BNfuHIEzT+XE6gVaeXEClwPClWjgSjKQnRgyUZwoDlDIzlF0IGUkO7cP00kP27efwpknduKVi3Q5Yn0aB1ixhqMaCzYbkgXjKGaH0rUZ9HD92zu4BU9wHNqJ0xfpXAiwFQ05ZQ0pRqKDUF++IUOIHUFqIVc+s9DD9JvvcPsQJj2+E6cTaRE2InTWxiI8ci7RLjxgBwmzkxoAPi+OxWuz+Fm/+f3jKdlSJxJpieBmUhzGNBsRRqDTqaF83zqQuVEMd/DrdawyRsrkFhBMv/4RHzyRE4m0k2MDaacuwtBG3ahPMhA7GIWON9Y6pYEYzjv7bg7GVjR0emOBM6NOvHyJNiApTh8Vp4JIMAZ1pEZiiXAsaMiKZO9XgaA4tmRjLEgD+eNYItnpeuTL5g5eO9CJFP1wHO7G6J/haI8ojp5DiTwbjcNE2RBYwBl1WmoG6nWo4ElNwYx8eYTwenRmznYH60R3AjbZASbkiGRipwMO8BiijZXB/RDtbFhfeMBcAuWOcACajOeKn58hDl6ca/XEPtwazUQi8B7ArhDXSyYFMjAChYspaIJ9Q3y+T0Juj/U2YyDZJHMfXdXPn7c+/xl3XCb2Cd41qoFB5a6ODtUOpO+JKgu/TybiQ7SS8al2BGo4shB+nQ1aHi8FK439Gts+kZRgJHFfKU3BLkMAGbfUkHGQ1MFIzYAYiioCToYlUKhGmmeG1sTyEI2yxXsnGyfijQdsjBCMo1cVI8cVcJHFQG3DF/RZDP49Kv0Wz+Uzw/PrNTTqNRtzQooSkny0x6nViQlKPooCH3JG6OTW+CpjnTE8GFu6KoOYFXHeOrEHMwT12vJCImjUyaiXJR2hOuOijuZ9KZIIthlkBwf4GagmWCUhYETkOtSNODGZxPTsqfwhVfIK2gchgBYqnSxjHxpiisMu6gyRUhxDdmiM7Npf5fcovRPb993GibjagtCVqHBrnSumFh7weOeojxGQHXWQqcjLgeIxbJMYLIwNQniev4/DQzbdVew33ieq8O912/MC3HMGt5Wet20LVO07VRlo+yuo+Eef/oLB8lmO+PIDKUKtEbwqy1miInmVoejfI86g5VaZA5m8TrZ7z5swIhZJSa3dE/tPWcDI8jHYJWXGpCXpADfoi5G9wTc7oAZppR+RaayzBNpEBoWaICEGzznhM0GwmziApCktVdKt4KwUlwlFbiuyc5cqawdRNpKOl6yAdMapjposCmQXOpHWumngwXBUWbU8QTuwhw6i9k1ieAUXDCYoRrK5xRnaEtO3cRA5eFSUbHchnJD1WrGHWDVvtUyOdLm22rpraAVBJRtNF4useI7oRsILvGYLnYgQmlmsMqFLb6OdrGIaWIY7xi40xEbjiOWDhRkXSmlbuqrS2+AEU61bJwLMhYzURNRVbblnVl5IhvgwrDUGoQiVMRZKSNV6oiysSuGkEnnb/lPXH+BE3Mia12ms2oWsNHYtrUSEAJItHCOjKV7NGrtkkoxIcBFEbjm6XEQx/jlAYinDqUzAhtZyy20ylevYQBCMNBe4oXKhLnwOShI8MM4wF7CsKvEgOMU0RUiBhQxaZ3w7PtbV3h/GAJFXMh0uirFx1zBee7Xinq/sVkzIO35sH/5a6MSxaECPJsVlcrMjISpkVImNuBq3VDbhMY8vztJ6nOqmmYtMBmwj6vqp9MyHv/mtm2bL5sI7xItyt+k1VitMVuY3fsCTcMjjy7OUdvpOlbmEuMyDWs1KMOcf/ernCvXAEcNzKUgg1TQXvzwYTdD1V6mOrFxZo1U4jANv0io7YMZpucH3QNb7s3qsSX0hYTrtdAeNjKQWerdnZNcZ6fvuZ+fofsi/CqlsFlIHI6XDfYQLct3UBNQ6wesWCH4fd77ciWSEwof1O7UDolKD4pBTsTThqfjAKmb1iG+UlRi6xX3uycz73BTaWiEZqVpyzI3pwxGbm0zMWEZNBHgNgBxJKXzl2Y7Vp7Tnph/iDlQ6UWzhInwIJJvRQ1fM1bvMkzrj2dJMpB8JQYuWi7ZNrdsn9eTLUTU7ggieQxJ5X3u0zQCFWckaX8d4shxO8YUZQ8Ku0tzCnyMI0PRZqLWA23ndACBZJ2cHVCCcY8KPqi0pCJgtdSJVwxI5Ql3UuI2xQaHARMi2DwDafqBpSchtQGh2yn4t8w19VW+bP/CFDmCEE/AvbNcVkxdGbv/HGC/3bcQr48v2I9g1ht3v7XrDBTPPsFGtiKD9Du4tdWIrbpnHwb8KBt/Ya70IvcCm0fLSI+kuIC9wMtnRkB4sJIORbCZyRz4bkzQ+wvX37uN8eSbi8cIeXIs3drBWn5HfHqSKl9bBqEmCnO43gVmhmR1vUSwwuGc4e0htn/8Dp2P2Hvib3Sdv03qc5OM4yJrDKYi82l9L/RqBvLMm4nWzZ1sNd7/LhfP3ON70/J95G//58Swf/wHWwCJbex0KvwAAAABJRU5ErkJggg=="
                                                                                     @else
                                                                                     src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAwCAYAAAC4wJK5AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAALvSURBVHgB7Vm9UuMwEF57MtBARRWaozqau+a45mguL3CPeh0PAA00hAaaUIUGKmhMQ5qwO5Y867W0SLGMlRm+mR1I9JP91t+uZAngC3mggAGwXq+n+OcE7QBtF+0N7QnttiiKJ0iMpCSY84dKtyXaJZJ5hURIQgKd34Pa+eOIYQu0eQoyvUig8zv45wfaT6hlI0HSqdD20aaeaa7R7vuQ2ZgEEiDnKfo+5ynKj6z/d9N/39G/Mv3vYQNEkzC6n3mcoQS+0pwZgkwwiQ+Slpy/I0MH3gKmo/loLiLkI3MeWsk+JGGSdgb+inOLdhPqvJibCFgyLgQlf6H8gE3a354uFCWKVgU90ZdM4Zn0F+gVp5W0qWDIzECpZPi7N/LLQkxC0f8H9UorQRGnpF3CwAhI/v/ox8p+IUn8he6CFZ20qaCQeURfzuyHCRtACSwJzGEE5y2o1KJfS6ilfcKaDqla2upVsoYjMQcl7XwsAhYkG/ID/z0TTY3kOQmZxMl3mz0hq2Djb6l02oG8IPOi8bdUBu1B3mhkzknIhWQX8oIMalNit1lOTdA1OeX2JGRQu3Jy7IFcq+WYaAWVr9jySXAiOcupFXBNTrmR4P6oJHiFyk1O3qBuq5xay8FWVCfzisChyqkSg3ORlPSjtSkttcaMIFWx4h9KrRHy2T9FyUnun3KRk3ffRJiIRimnqAqFOXQQOIZedJ4hHKqcJlojRFQoJPAH6tfI0P4LJHIR2L2lCLlFKrVGCJSTKYHBBAyOI6off7qd4uNaJ6IrlNmMxR6iVREHb1wRnTETx4AVGxRTnehFPjQnCA8QDu6HlLyXhEVwdTJR7X2k6QEPTIeES05DOdIHqpxcJDZ6EkPBkfzxTyKD/ZP3qMYipDp9g3EhT8g71dOV2HTVdMo+n+LToAuWFXw+qCrJy53OyWSHBNV8dJpuf/jidQR54JofEFj4XoroADe3s9iF64KFoN7ZmfsBOu6fwjgg/b/AQDdTX0iNd+u2/S+8Yl30AAAAAElFTkSuQmCC"
                                                                                         @endif
                    >
                </div>
                <div data-v-d42c1f6b="" class="tab-item-label">Home</div>
            </div></div>
        <div class="tab-item"  onclick="window.location.href='{{route('vip')}}'">
            <div data-v-d42c1f6b="" id="tabItem" class="tab-item-inner @if(\Request::route()->getName() == 'vip') active @endif">
                <div data-v-d42c1f6b="" class="w-full flex justify-center icon"><img data-v-d42c1f6b=""
                                                                                     class="w-24.78px h-24.28px"
                                                                                     @if(\Request::route()->getName() == 'vip')
                                                                                     src="data:image/png;base64,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"
                                                                                         @else
                                                                                     src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAwCAYAAAC4wJK5AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAUjSURBVHgB5VotcxxHEO1TuU7EIrZJjDZEIlZARBKHBDkkIhFK/qBDbBIhm5xRiM7kRHzEZyIRn8mZSESeV9sj9bztmf24NbFf1dZqd2dn+/XXdI9O5BvAREbCzc3NNJyqcDwMx+Nw4HrPDNnosdbjYjKZfJYRsDWJIPwP4XQkteB9cRGOZSCzlC0wmIQK/7uk2h4KWGg+lExvEkH4+1IL/7hFKLjMtbkHsnCxh4X33klNppeb9SIRCDwIpz/E1/6lCvEhCHFVmAPvwooHemZAAa/CHGvpiM4kwsf3w+nXcOzSIwgP7V1ITyghxNO+83jW1b06kQgfq8LpGd2Gxt4MEd6ZHyRAhi38X5j/su39VhIaAyeSWgCmhsk3MhLUKlCUjRm45Yu2GOlC4m9JNQQCpzm/16wV/R2BvGve+yh1zKwy72L8MRHZKJFrGUIiTAoTH9GELz0CYewTHbsr7cimVCUCy1vFnYWxb3OTZUmoG/1Dt5+zC3VMuTkgnmbsLupaf8mdQoputSN5HNH1WYYAzO8RwNilHiup3YmB9451nlvod87NLZA5lAzueTd10gMrEJvT+C9nFAi98PJ8JqXuKRH2+0U4nsidNfbDmLkXGzlLsGbnzhhOiTA5An6WW6igYTzHOKktZYn8TGMhLFvDW0+yJA7oOsnVaqlDIvCy65qh417pexE/aWazWNCYypsvR8JOduGsBxwv875rhlqLM05FY2CNT+aWW3c1YiJogweunPcq8zdc5NyZB/4Ma8FVQHDB48L1QsdFt/T8/r3cKXUX8rG7epbgQF2TcIgXuxYspEkANdZTMxfOT8P9X6QJu1ZgXlYip9WGNTwS9+mas8EDumaS+EguHXp+z7VRUYlSVwEJPBK84l63PGdNVVIGa5Jjqa3JalQEOzI+rqSnENtiZ4AQrDl2v09Sxoqu91q+P2157q7YXgxYwdl94OO3fo01ABlGhfuo80GQR1JnsrUzvwU/Z8s1UrlHgidhTUGwKzM5FsYk3wdBvRU+h2TRdJogJtkoAhvupJrKrpKaw21a3NNc3xu0RgAfnGE/SlO+BLnATlZJLfak8LFHMgxs5cSCWt4k1YM3iVvFCq2SUleTty6jfo9FDq4AH/3f+Tie7ev7GxWAt2MgdKVkFk7pwoWou3GQswQGW5c6dKwxl7sO7coQgA+fKIkYNxASsXNiyxp1zTiP17lxjXbZmYTj99EaPObUtpimScqtBbj/JzVBK3F6dm2Nrbstc0VmabFDscbW8DowC+6x8T5I2nFJlwZlZDrGRqUsGWRJZFrEY8etLGyA4/1/tQl6IR36AsB0jBZnpVK/rexYSLMDKxGx99fRRdT1WjfBMi3vprTTARRJRL+XVIsIzEZz74CJspslMPHEm2en0oLWAlDN+JpuRyIV3bfpk9cASzopbTSjMQHgTZeOsVMVqz3xjG5DSF6p7QenzvgIrs9+k+amwyy3U8i4Jx2BVBo0hiX/maQdm9DHI9BKTuGSTgyxdqf0rNfWfq9+QieGjy6dj0cBLOxiVxoXXQ3Bf9qHANDZEhHqo7OgXbjYUdS2Pr52hMP4tnIa772eDPw3QW8SEbpScy3DZTIsAO0W+/Yw13PZAmO3pzlfZ3fKbtMPwdgkOP9H4dtiZyuMSkJjI8lQek7S56TwD5MhGBwTBSAu7E52/KVBxKhWAL7Gls2Kriu63urXAx6+BgkUjbk8v/b2bbfFaD9QYWhTg/Y0bijDAueTwj/qv2t8AasU/7365zaDAAAAAElFTkSuQmCC"
                                                                                     @endif
                    >
                </div>
                <div data-v-d42c1f6b="" class="tab-item-label">Products</div>
            </div></div>
        <div class="tab-item" onclick="window.location.href='{{route('ordered')}}'">
            <div data-v-d42c1f6b="" id="tabItem" class="tab-item-inner @if(\Request::route()->getName() == 'ordered') active @endif">
                <div data-v-d42c1f6b="" class="w-full flex justify-center icon"><img data-v-d42c1f6b=""
                                                                                     class="w-24.78px h-24.28px"
                                                                                     @if(\Request::route()->getName() == 'ordered')
                                                                                         src="data:image/png;base64,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"
                                                                                         @else
                                                                                     src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAwCAYAAAC4wJK5AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAPjSURBVHgB7VmvVxtBEJ7k9VFDTVsDpqkBQxENomCICoaY4qr6D7YGVDDBQAVUNJigosCUmtSAoTPNXDqZ7O7s7l0ak++9fZdMbnb3252dHxuAJZZYQqIGmXh6elrDR4PbC8jHA7Z7bDe1Wu0GMpBMAie/go8mtndQPUbYLpDMMEUpiQQT6GB7BfNFL2VXnkEa2jBLgFbvDvJBprimZC1csBESieo3eiew0318bCrxOQ50DSWBfRORXRifrwJ0Vr5g/78t/TpEAAehM6AJ9KogQMB+aNW7MD7gBZ5j6+DYq5a+SYIJNJX4PNeTGDiGsXkWoB3q8Fn0IkjCQ+Cyqh3QwH4f8XECs0TaIT0vCSSwAW4C32GOINPCB5nWgxCv43w++HScJDiQtZS4P28CBXAcOhtnSryN83rven+GBL74Ema3b4AdX8B/BAc8PeYOzm9LvztFgj3BAYw9QwFalW+wACCRPj6ulLiJ85yKVXon6AzIPIjs8wQ7e4AFAccmEgMhogXele9MSLAbk7HAJEA6elVSQfpWLMA50PmQMWRdul25E+tK94o9hW/wBj4+YzvyHTgLqEcreoTtEzuTEPrqe6P4IEnoFb2HMBri804qEY5BMhPeNFR0HjUx+1Cwe4QwbtX3aCKeIHoLmZAktO1bdkpph/YcOxwkvQgEUSuN0Zbys/ggSfxSLwUnQ2DPoW215bPvkkFUE5/Mty4mRNspD/KmtaqsRwFpoMRt7bXKBFE2P9nfrXQ6+kxo82hFulCaiE6j24XrLBNEOUI3HeNNMEWC7XKoFA4tIpx9+tJoMqEOZARR3r09Jb7k3Orf+A5FVx1Ngx5bVRZXaIcQvv0oCIyMvlZhlnzfZX4zLtZYVctj/Z2g0s0hsALu3XM6gLpnMr7i5MCqsjz1APD3rkWAsQ8J5lc3JnOiJkMm1gEDbLOnSnymbdkF9kRvhYjGD+6eedvBh5rsXHqWASdllu5rfLzBdscu3HqfPJE+yF3rMi3qyoaTPe3jf2DnldUZwotJRJXDUVc2vBI9Jd7OzV412GG0lDi6HI4iQQjkSltQAh5Xep9SDkeTIHCupInsxaQnAVAk156oCwlIIkFwlIuE2PRkClwUST3TE7mQTILAnmmoxIcpRBxFEeE0lQAhiwSjB4GkLwT2dq6aIqswyiaRm57wb/tKXOpmscxOhNITJxHhiWTgHJa9Wcz+z06Cs9ePMD05IkbmccNyCmYbjne+lr3XqoQEwZOehBCV0cagMhIEJkLpifVvamUECJWSILBpkech89FkyGzov43rKq9GKychgYToVrGoP0YxqfgSSywYfwAsG8FZ/anwhgAAAABJRU5ErkJggg=="
                                                                                     @endif
                    >
                </div>
                <div data-v-d42c1f6b="" class="tab-item-label">Ordered</div>
            </div></div>
        <div class="tab-item" onclick="window.location.href='{{route('user.team')}}'">
            <div data-v-d42c1f6b="" id="tabItem" class="tab-item-inner @if(\Request::route()->getName() == 'user.team') active @endif">
                <div data-v-d42c1f6b="" class="w-full flex justify-center icon"><img data-v-d42c1f6b=""
                                                                                     class="w-24.78px h-24.28px"
                                                                                     @if(\Request::route()->getName() == 'user.team')
                                                                                     src="data:image/png;base64,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"
                                                                                     @else
                                                                                     src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAwCAYAAAC4wJK5AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAJtSURBVHgB7Vq9UsJAEN4wDDbaiA1U2OADUFGZSisbXxUaqWJlIz4AFTaxERtooMH95HAuyyUZcvm5zOSbucnccZfsd7vZvexC1MANeEk/7vf7Dl+G3AbcutwuqDxsua24LTzPWyRNjCXBBHp88bldUfVYcwuYzJfpRyMJJoDd98k9BCattOUAE7jky1gMQ7U/dNiRsgAL6ImxMcsXMpGNPtg2LB5R1PZhlzNeWCaBP7DAIPJAh/eRlFw+t6k+ryUWQQt32hAEn1ZBAFDPnVDUAvrK4fyjJdbdiP6cb7SlCsHP30EOMTzQO5JEV/RX5AakV4p4zBYlY0c1QBqJWqAh4QralAHKFfvc+mQPOI+J8kKZkFUTA8qHAACPOCQLZCWxoXxh5QUzmROrfskmFVA+2gjTjtppyEQCUA+2enheaFysK2hIuIImYtN5LtY6MsehzIhtHZnjUHbELuT7pMyIbROZO6If+WSuS8SWmcdI4qIu3ula9CPmXBcSt3qHrSCSwHCehHLneiYwlHPqoAnpPE7ewzqQGIn+SWbcaRJsSiCgJ8oWppSqsyTUuyC1MDfNdZKEShg/ieH3uMS2cyQ0AroZrZnAR9yazBG7CCgTeqRoYhtHjGnSOklCqqtHJVWHEmqEr2n1EUliKfojvvmyiG+AI5TweIFlPIAG3nDYTLuHZ7gp7FGPkAjxL7JOZgNl9wM6fF+YTsLY+Zk8XsTBRALqfKbTkyPCvS0RCA97TyorI5gF55TYXCoBQ2jYf3juwqRiPNR8T8UX47Hz8yzCH+GlTVBaQUUVZ3rbv0Vgt+EkIPg3t8+qC5sN8sQvFUq24X7h5TMAAAAASUVORK5CYII="
                                                                                         @endif
                    >
                </div>
                <div data-v-d42c1f6b="" class="tab-item-label">My Team</div>
            </div></div>
        <div class="tab-item" onclick="window.location.href='{{route('profile')}}'">
            <div data-v-d42c1f6b="" id="tabItem" class="tab-item-inner @if(\Request::route()->getName() == 'profile') active @endif">
                <div data-v-d42c1f6b="" class="w-full flex justify-center icon"><img data-v-d42c1f6b=""
                                                                                     class="w-24.78px h-24.28px"
                                                                                     @if(\Request::route()->getName() == 'profile')
                                                                                     src="data:image/png;base64,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"
                                                                                         @else
                                                                                     src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAwCAYAAAC4wJK5AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAANSSURBVHgB7Vo9c9pAEF08mdA4je3GNKEJaUxFGqcJPyD+qelSpbKbOIVFEdyYNKSJG6hIQxqyz1rJq+V0EvpCzPjN3MDdodO+2727vV2IXtAOdKgibDabU/4453LGBd9fc3lD5bHksuASdDqdv64flCLBgkPQCy7vqRqBs/CTifywjYVIiPCXFArfNB6YyI1u2JkEE8DMj7h0PT9bUWgG/6g8YKJWy9+ZyH1UeUU5wcIf88eYS8/Rvebyi8ucy5JfsKYKwe/GpI1UE77vRkIIXNH2jKxlsPuqBdfgsQMx4aE0dbl+zu2PqGSS8BCYcpnUKbzBb3omAWAHzCaRQgD2fsPC/6FmsTL1eE2mkhD1uQh8ZQIrahGOPH1YPK0nADhJsBb6lLQ/2H0rCQBpmrg09aCtBIAtEqyFASXNaK4PljbCpYmhqd9Sy5EgIZ7oqWqatdmMIlhNDEz9gQ4AloT2i1bRsd52xIedHG7alJa+B41DeMeEJ6a/zx+fKPRkv3G/d7wy0Jo4M31ZbkWfnjX3QSZBI3LXsdMNqUZoElaIrJnrZtT1eMdUI448L6riQtMINAk7kwdJ4mChSTR1uSkKu2ZjeTUJaz4n1C5Yc489CU3C7kZZcaR1Rl2jivV1kjamJmF9JHtuWMwoJA7hcdhZQQMZE6UKJ9JGWeJJj09sCMEHFjqiU/steSBCf/H0g+SMqoP2JhZ60uzuNFffn8Ii1AKwHNCCNu+ET2dJWIdvRO3AO1NPaDhBQsIwmkhv39oQR1PHfBfWmXQddvYOsW9tfDT1ravyFglZkJppT4LIjUPe21dNK5EvgTS3w26JI1FrY5D3WStwbtVOErI2pqoJp+VVU0RU+FSf0lOWa+76vc8BjA6rCNjiaifiif9O0p7pZAyIgT47Bryu4/4tO+GYdgyfZmaKUogAdxTmJUr7RXK1hf3ba2yu+G+udJeHCAYPXDtGznGjxCWEd3mpueK/uXN2QmRMYQ6NHC/EZvC0Pfu0o6IqfQrjXK7cH0z1Om/grkjiEWq/IH/iMfJudd45Et7n4uOZYNfYb9EUMAQBmQFVB2jxtkj6rGwyHmQGUook42EuEL5U4rKOv0XAbYapYb+3WyXWSvQ3h8c6o4Iv2Af+A6AXJLraDRMLAAAAAElFTkSuQmCC"
                        @endif
                    >
                </div>
                <div data-v-d42c1f6b="" class="tab-item-label">Me</div>
            </div></div>
    </div>
</div>



{{--<uni-view data-v-26ea959c="" data-v-9012a3ca="" class="tabbar">--}}
{{--    <uni-view data-v-26ea959c="" class="bar">--}}
{{--        <uni-view data-v-26ea959c="" class="baritem @if(\Request::route()->getName() == 'dashboard') active @endif" onclick="window.location.href='{{route('dashboard')}}'">--}}
{{--            <uni-view data-v-26ea959c="" class="img">--}}
{{--                <svg data-v-26ea959c="" t="1711507607647" viewBox="0 0 1024 1024" version="1.1"--}}
{{--                     xmlns="http://www.w3.org/2000/svg" p-id="6537" width="48" height="48"--}}
{{--                     class="icon">--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M521.9 456.5c0 5.5-4.5 9.9-9.9 9.9-5.5 0-9.9-4.4-9.9-9.9s4.5-9.9 9.9-9.9c5.5 0 9.9 4.4 9.9 9.9z"--}}
{{--                          p-id="6538"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M279.4 363.6L512 456.5 326.6 314.6zM335.1 305.6l51.4-51.3L512 456.5z"--}}
{{--                          p-id="6539"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M483.4 389.6h57.2L512 438zM558.9 443.8v24.7l-32.8-12z"--}}
{{--                          p-id="6540"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M744.6 363.6L512 456.5l185.4-141.9zM688.9 305.6l-51.4-51.3L512 456.5z"--}}
{{--                          p-id="6541"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M279.4 549.4L512 456.5 326.6 598.4zM335.1 607.4l51.4 51.4L512 456.5z"--}}
{{--                          p-id="6542"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M744.6 549.4L512 456.5l185.4 141.9zM688.9 607.4l-51.4 51.4L512 456.5z"--}}
{{--                          p-id="6543"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M465.6 443.8v24.7l32.8-12zM585.6 690.8l-8.9-109.2L512 475.1l-62.6 106.5-9.5 109.2h46.9v-80.3h50.4v80.3z"--}}
{{--                          p-id="6544"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M920.1 852.7l-46.6 41S608.2 737.9 65.7 737.9c0 0 439.5-68 854.4 114.8z"--}}
{{--                          p-id="6545"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M90.5 781s374.2-23.2 760.4 135.5l-46.6 37S536.7 823.2 90.5 781z"--}}
{{--                          p-id="6546"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M117.3 445.7s20.5-68.5 61.2-83.7c40.7-15.2 62.3-19.5 81.3-18.8 0 0-55.6 69.4-74.8 85.1-19.2 15.5-55.2 24.3-67.7 17.4zM166.4 333.9s29.7-41.2 69.7-47.6c30.7-4.9 73.6 12.2 73.6 12.2s-99.7 70.6-143.3 35.4z"--}}
{{--                          p-id="6547"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M227.7 267.4s35.4-35.2 75.7-36.9c30.9-1.3 70.5 19 70.5 19s-108.6 55.1-146.2 17.9z"--}}
{{--                          p-id="6548"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M306.8 214.2s33.9-25.9 68.3-22.8c26.4 2.4 57.7 24 57.7 24s-98.2 34.6-126-1.2z"--}}
{{--                          p-id="6549"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M380.7 178.1s32.8-19.3 62.9-12.8c23.1 4.9 48.5 27.5 48.5 27.5s-90.6 20-111.4-14.7zM467.6 163.7s27.6-14 51.7-7.3c18.5 5.2 38 24.7 38 24.7s-74.6 11.7-89.7-17.4z"--}}
{{--                          p-id="6550"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M746.5 252.2s-59.7-54.6-198.8-76.5l-17.4 6.5c-0.1 0 81.7-7.3 216.2 70z"--}}
{{--                          p-id="6551"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M71.5 406s43.9-56.5 32.6-98.5c-11.3-42-20.3-62-31.9-77.1 0 0-24.2 85.6-25.8 110.3-1.6 24.8 12.1 59.2 25.1 65.3zM116.2 318.6s43.1-26.9 52.2-66.4c6.9-30.3-7.2-74.3-7.2-74.3s-77.1 94.8-45 140.7zM183.6 243.4s47-16.8 65.9-52.5c14.5-27.4 13.1-71.9 13.1-71.9s-96.4 74.4-79 124.4zM270.6 189.3s41.5-9.8 61-38.3c14.9-21.9 18-59.8 18-59.8s-89 53.9-79 98.1zM350.3 157.5s37.1-8.5 54.6-33.8c13.5-19.4 16.5-53.2 16.5-53.2s-79.8 47.6-71.1 87zM416.3 137.8s30.8-2.6 47.8-21c13-14.1 19.3-41 19.3-41s-69.6 29.2-67.1 62z"--}}
{{--                          p-id="6552"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M955 747.1c18.5-48.4 28.1-100 28.1-155.2 0-250.8-210.9-454.1-471-454.1s-471 203.3-471 454.1c0 42.3 6 83.3 17.3 122.2l44.6-6c449.9-51 826.4 99.1 826.4 99.1s21.3-49 25.6-60.1z m-858-62c-7.1-31.1-10-60-10-96 0-243.8 178.6-442.4 423.1-442.4 244.5 0 427.2 198.6 427.2 442.4 0 50-7.7 98-22 142.8C618.1 626.3 223.9 667.7 97 685.1z"--}}
{{--                          p-id="6553"></path>--}}
{{--                </svg>--}}
{{--            </uni-view>--}}
{{--            <uni-view data-v-26ea959c="" class="text texta">Home</uni-view>--}}
{{--        </uni-view>--}}
{{--        <uni-view data-v-26ea959c="" class="baritem @if(\Request::route()->getName() == 'ordered') active @endif" onclick="window.location.href='{{route('ordered')}}'">--}}
{{--            <uni-view data-v-26ea959c="" class="img">--}}
{{--                <svg data-v-26ea959c="" t="1711507630801" viewBox="0 0 1024 1024" version="1.1"--}}
{{--                     xmlns="http://www.w3.org/2000/svg" p-id="7776" width="48" height="48"--}}
{{--                     class="icon">--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M 479.744 311.296 s 525.312 72.192 537.6 148.48 c 12.288 75.776 -159.744 452.096 -279.552 484.352 c -119.808 32.256 -724.48 -159.744 -726.528 -238.08 c -3.072 -108.032 70.656 -262.656 468.48 -394.752 Z M 371.2 437.248 c -46.592 46.08 158.72 66.048 183.296 62.976 c 24.576 -3.072 105.984 -87.552 89.088 -96.768 c -16.896 -9.216 -185.856 -33.792 -185.856 -33.792 s -39.936 21.504 -86.528 67.584 Z m 274.944 44.032 c -32.768 47.104 155.648 81.92 175.616 88.064 c 19.968 6.144 56.32 -27.648 70.656 -39.936 c 14.848 -12.288 19.968 -30.72 7.68 -48.128 c -12.288 -17.408 -187.392 -68.608 -187.392 -68.608 s -33.792 21.504 -66.56 68.608 Z m -234.496 250.88 c 21.504 36.864 234.496 59.392 234.496 59.392 s 121.856 -111.616 140.288 -161.792 c -27.648 -50.176 -230.4 -75.776 -230.4 -75.776 C 465.92 626.688 423.936 695.296 411.648 732.16 Z m -263.68 -138.24 c -100.864 89.088 93.696 113.152 141.312 110.592 c 37.376 -2.048 159.232 -125.952 168.448 -150.528 c 9.216 -24.576 -168.96 -62.464 -168.96 -62.464 s -39.936 13.312 -140.8 102.4 Z m 200.704 -346.624 s 53.76 88.064 155.648 47.616 c 0 0 -50.176 -75.776 -155.648 -47.616 Z m 68.608 -79.872 s 10.24 70.656 86.528 71.68 c 0.512 0 -10.752 -61.952 -86.528 -71.68 Z m 183.808 0 s -10.24 70.656 -86.528 71.68 c 0 0 11.264 -61.952 86.528 -71.68 Z m 76.288 79.872 s -53.76 88.064 -155.648 47.616 c 0.512 0 50.176 -75.776 155.648 -47.616 Z M 506.368 186.88 s -38.912 -30.208 1.024 -115.2 c 0 0 44.032 75.264 -1.024 115.2 Z"--}}
{{--                          p-id="7777"></path>--}}
{{--                </svg>--}}
{{--            </uni-view>--}}
{{--            <uni-view data-v-26ea959c="" class="text">Income</uni-view>--}}
{{--        </uni-view>--}}
{{--        <uni-view data-v-26ea959c="" class="baritem @if(\Request::route()->getName() == 'spin') active @endif" onclick="window.location.href='{{route('spin')}}'">--}}
{{--            <uni-view data-v-26ea959c="" class="img">--}}
{{--                <svg data-v-26ea959c="" t="1711528708446" viewBox="0 0 1024 1024" version="1.1"--}}
{{--                     xmlns="http://www.w3.org/2000/svg" p-id="4791" width="48" height="48"--}}
{{--                     class="icon">--}}
{{--                    <path data-v-26ea959c="" d="M479.2 669.8l64 0 0 62.9-64 0 0-62.9Z"--}}
{{--                          p-id="4792"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M512 320c-70.6 0-128 57.4-128 128l64 0c0-35.3 28.7-64 64-64 35.3 0 64 28.7 64 64s-28.7 64-64 64l-32 0 0 102.2 64 0L544 572c55.1-14.2 96-64.4 96-124C640 377.4 582.6 320 512 320z"--}}
{{--                          p-id="4793"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M512 0C229.2 0 0 229.2 0 512s229.2 512 512 512 512-229.2 512-512S794.8 0 512 0zM828.8 828.8 701.5 701.5c-32.8 32.8-74 57.1-120.1 69.4l46.6 174c-37.6 10.1-76.4 15.1-116 15.1s-78.4-5.1-116-15.1l46.6-174c-46.1-12.3-87.3-36.6-120.1-69.4L195.2 828.8c0 0 0 0 0 0-41.2-41.2-73.5-89.1-96-142.4-8.1-19.1-14.8-38.6-20.1-58.4l174-46.6c-5.9-22.1-9.1-45.4-9.1-69.3 0-24 3.2-47.2 9.1-69.4L79.1 396c5.3-19.8 12-39.3 20.1-58.4 22.6-53.3 54.9-101.3 96-142.4 0 0 0 0 0 0l127.3 127.3c32.8-32.8 74-57.1 120.1-69.4L396 79.1C433.6 69.1 472.4 64 512 64s78.4 5.1 116 15.1l-46.6 174c46.1 12.3 87.3 36.6 120.1 69.4l127.3-127.3c0 0 0 0 0 0 41.2 41.2 73.5 89.1 96 142.4 8.1 19.1 14.8 38.6 20.1 58.4l-174 46.6c5.9 22.1 9.1 45.4 9.1 69.4s-3.2 47.2-9.1 69.4l174 46.6c-5.3 19.8-12 39.3-20.1 58.4C902.3 739.7 869.9 787.6 828.8 828.8 828.8 828.8 828.8 828.8 828.8 828.8z"--}}
{{--                          p-id="4794"></path>--}}
{{--                </svg>--}}
{{--            </uni-view>--}}
{{--            <uni-view data-v-26ea959c="" class="text">Promo</uni-view>--}}
{{--        </uni-view>--}}
{{--        <uni-view data-v-26ea959c="" class="baritem @if(\Request::route()->getName() == 'user.team') active @endif" onclick="window.location.href='{{route('user.team')}}'">--}}
{{--            <uni-view data-v-26ea959c="" class="img">--}}
{{--                <svg data-v-26ea959c="" t="1709016833662" viewBox="0 0 1024 1024" version="1.1"--}}
{{--                     xmlns="http://www.w3.org/2000/svg" p-id="56660" width="200" height="200"--}}
{{--                     class="icon">--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M741.072 488.962a8.864 8.864 0 0 1-8.87 8.87c-4.874 0-8.87-3.966-8.87-8.87s3.996-8.868 8.87-8.868a8.864 8.864 0 0 1 8.87 8.868z"--}}
{{--                          p-id="56661"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M741.072 488.962a8.864 8.864 0 0 1-8.87 8.87c-4.874 0-8.87-3.966-8.87-8.87s3.996-8.868 8.87-8.868a8.864 8.864 0 0 1 8.87 8.868z"--}}
{{--                          p-id="56662"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M990.064 659.456l-1.5-0.438c-22.014-5.902-29.476-11.584-39.25-15.3-34.754-13.238-43.808-22.792-46.122-27.292-0.094-0.188-0.156-0.344-0.218-0.498l-0.282-40.376-64.7-0.938-64.7 0.938-0.312 40.376a9.3 9.3 0 0 0-0.188 0.498c-2.308 4.498-11.366 14.052-46.15 27.292-9.804 3.716-17.236 9.398-39.22 15.3l-1.528 0.438c-20.046 6.62-33.508 25.2-33.508 46.184v58.296H1023.6V705.64c0-20.986-13.488-39.566-33.536-46.184z"--}}
{{--                          p-id="56663"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M952.374 497.05c0 74.316-70.85 142.702-114.378 142.702-43.528 0-114.41-68.384-114.41-142.702 0-74.348 51.21-123.374 114.41-123.374 63.168 0.002 114.378 49.028 114.378 123.374z"--}}
{{--                          p-id="56664"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M768.862 437.286c181.172-30.476 157.252 194.722 157.252 194.722 78.69-66.542 43.092-267.166-43.778-281.216-87.556-14.146-109.698 16.268-109.698 16.268l-3.776 70.226z"--}}
{{--                          p-id="56665"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M773.638 364.842s-68.04 29.726-68.04 97.518c0 72.068 25.792 111.912 25.792 111.912 0.812-106.072 46.432-138.828 46.432-138.828l-4.184-70.602z"--}}
{{--                          p-id="56666"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M373.67 659.424l-1.514-0.438c-22.014-5.902-29.46-11.584-39.266-15.3-34.77-13.238-43.81-22.792-46.122-27.322-0.094-0.156-0.156-0.312-0.234-0.498l-0.282-40.376-82.466-0.938-82.452 0.938-0.282 40.376c-0.076 0.186-0.138 0.342-0.232 0.498-2.31 4.53-11.352 14.084-46.122 27.322-9.804 3.716-17.252 9.398-39.266 15.3l-1.516 0.438C13.874 666.074 0.4 684.654 0.4 705.638v58.296H407.19v-58.296c0.002-20.984-13.474-39.564-33.52-46.214z"--}}
{{--                          p-id="56667"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M318.214 497.332c0 74.348-70.882 142.764-114.428 142.764-43.542 0-114.41-68.416-114.41-142.764s51.226-123.374 114.41-123.374c63.202 0 114.428 49.026 114.428 123.374z"--}}
{{--                          p-id="56668"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M262.852 380.362s-2.216-19.766 21.466-34.006c10.04-6.026-150.352-34.598-190.602 66.73-15.128 38.094-3.95 94.114-3.95 94.114l34.864-62.482s37.986 8.868 79.156 8.868c41.172 0 80.546-8.868 80.546-8.868l33.88 52.802s13.02-50.71-1.562-84.308c-14.58-33.6-53.798-32.85-53.798-32.85z"--}}
{{--                          p-id="56669"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M779.198 683.716l-2.03-0.624c-34.848-9.43-60.39-18.422-75.754-24.356-54.458-20.952-68.666-36.064-72.256-43.214-0.124-0.25-0.25-0.532-0.376-0.782l-0.5-66.636-232.644 2.688-0.454 63.95c-0.11 0.25-0.218 0.532-0.344 0.782-3.624 7.15-17.798 22.264-72.272 43.246-15.364 5.902-40.922 14.894-75.426 24.262l-2.374 0.688c-31.396 10.492-52.522 39.938-52.522 73.13v92.366h639.468v-92.366c0.004-33.196-21.072-62.642-52.516-73.134z"--}}
{{--                          p-id="56670"></path>--}}
{{--                    <path data-v-26ea959c="" d="M547.502 721.312h-71.052l-21.296 127.9h113.676z"--}}
{{--                          p-id="56671"></path>--}}
{{--                    <path data-v-26ea959c="" d="M547.502 721.312h-71.052l-28.414-113.256h127.916z"--}}
{{--                          p-id="56672"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M693.17 426.418c0 117.752-112.222 230.946-181.186 230.946-68.96 0-181.202-113.194-181.202-230.946 0-117.72 81.124-195.408 181.202-195.408 100.062 0 181.186 77.688 181.186 195.408z"--}}
{{--                          p-id="56673"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M628.72 209.712c-30.79-27.916-134.098-62.17-237.126 0-52.178 31.474-90.164 170.524-90.164 170.524s101.782 57.674 234.272-4.652c79.282-37.314 77.5-17.768 100.14 16.206 13.426 20.14 57.328 34.628 57.328 34.628s34.16-127.462-64.45-216.706z"--}}
{{--                          p-id="56674"></path>--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M792.78 354.288c-11.208 4.278-16.922 9.274-19.078 11.554l-0.062-1s-12.8 5.59-27.322 17.486c-1.374 22.17-0.654 50.336 6.62 79.594l4.342-1.092c8.836-15.176 17.174-22.67 19.734-24.764 4.808-0.624 9.46-1.06 13.958-1.31-5.498-35.38-0.752-67.198 1.808-80.468z"--}}
{{--                          p-id="56675"></path>--}}
{{--                </svg>--}}
{{--            </uni-view>--}}
{{--            <uni-view data-v-26ea959c="" class="text">Team</uni-view>--}}
{{--        </uni-view>--}}
{{--        <uni-view data-v-26ea959c="" class="baritem @if(\Request::route()->getName() == 'profile') active @endif" onclick="window.location.href='{{route('profile')}}'">--}}
{{--            <uni-view data-v-26ea959c="" class="img">--}}
{{--                <svg data-v-26ea959c="" t="1711507688119" viewBox="0 0 1024 1024" version="1.1"--}}
{{--                     xmlns="http://www.w3.org/2000/svg" p-id="10680" width="48" height="48"--}}
{{--                     class="icon">--}}
{{--                    <path data-v-26ea959c=""--}}
{{--                          d="M742.4 371.2c128-19.2 217.6-51.2 217.6-83.2s-76.8-64-198.4-76.8C742.4 89.6 640 0 512 0S281.6 89.6 262.4 211.2C140.8 224 64 256 64 288s89.6 64 217.6 83.2C326.4 454.4 409.6 512 512 512s185.6-57.6 230.4-140.8zM595.2 512H422.4C185.6 512 0 697.6 0 934.4c0 51.2 38.4 89.6 89.6 89.6h844.8c44.8 0 83.2-38.4 83.2-83.2C1024 704 832 512 595.2 512z m-256 403.2c-32-32-51.2-76.8-44.8-128 51.2 0 96 12.8 140.8 38.4 32 32 51.2 76.8 44.8 128-51.2 0-96-12.8-140.8-38.4zM518.4 832c-38.4-32-57.6-70.4-64-115.2 6.4-44.8 32-89.6 64-115.2 38.4 32 57.6 70.4 64 115.2-6.4 44.8-25.6 89.6-64 115.2z m230.4-51.2c0 51.2-12.8 96-51.2 134.4-44.8 32-96 44.8-147.2 44.8 0-51.2 12.8-96 51.2-134.4 38.4-32 89.6-44.8 147.2-44.8-6.4 0 0 0 0 0z"--}}
{{--                          p-id="10681"></path>--}}
{{--                </svg>--}}
{{--            </uni-view>--}}
{{--            <uni-view data-v-26ea959c="" class="text">My</uni-view>--}}
{{--        </uni-view>--}}
{{--    </uni-view>--}}
{{--</uni-view>--}}
{{--<uni-view data-v-67ba0544="" data-v-9012a3ca="">--}}
{{--    <uni-view data-v-0008f7bc="" data-v-665e262f="" data-v-67ba0544="" class="u-popup">--}}
{{--    </uni-view>--}}
{{--</uni-view>--}}
