<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>History</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css">
    <style>

        *{
            padding: 0;
            margin: 0;
        }
        body {
            font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
            font-size: 14px;
            line-height: 1.42857143;
            color: #333;
            background-color: #fff url({{asset('public')}}/h5/static/img/bg.png) no-repeat ;
        }

        #exTab1 .tab-content {
            color : white;
            background-color: #428bca;
            padding : 5px 15px;
        }

        #exTab2 h3 {
            color : white;
            background-color: #428bca;
            padding : 5px 15px;
        }

        /* remove border radius for the tab */

        #exTab1 .nav-pills > li > a {
            border-radius: 0;
        }

        /* change border radius for the tab , apply corners on top*/

        #exTab3 .nav-pills > li > a {
            border-radius: 4px 4px 0 0 ;
        }

        #exTab3 .tab-content {
            color : white;
            background-color: #428bca;
            padding : 5px 15px;
        }
        a {
            color:#154de0;
            text-decoration: none;
        }
        #exTab3 .tab-content {
            color: white;
            background-color: transparent;
            padding: 5px 15px;
        }
        .nav-pills>li.active>a, .nav-pills>li.active>a:hover, .nav-pills>li.active>a:focus {
            color: #fff;
            background-color: #154de0;
        }
        #exTab3 .tab-content {
            color: #154de0;
            background-color: transparent;
            padding: 5px 0;
        }
        .history_list {
            padding: 5px 15px;
            border-radius: 8px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>

<div style="padding: 15px;display: flex;justify-content: space-between;align-items: center;">
    <div><img onclick="window.location.href='{{route('profile')}}'" style="width: 20px;" src="{{asset('public/icons8-chevron-left-30 (1).png')}}" alt=""></div>
    <div style="color: #154de0;font-size: 20px;">Histories</div>
    <div></div>
</div>

<div id="exTab3" class="container">
    <ul class="nav nav-pills">
        <li class="active"><a href="#1b" data-toggle="tab">Deposit</a></li>
        <li><a href="#2b" data-toggle="tab">Withdrawal</a></li>
        <li><a href="#3b" data-toggle="tab">Income</a></li>
        <li><a href="#4b" data-toggle="tab">Reward</a></li>
    </ul>

    <div class="tab-content clearfix">
        <div class="tab-pane active" id="1b">
            @foreach(\App\Models\Deposit::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
                <div class="history_list" style="border: 1px solid #12fff8;">
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>OID-S.N</h5></div>
                        <div><h5>{{$element->order_id}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Deposit</h5></div>
                        <div><h5>{{price($element->amount)}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Actual Amount</h5></div>
                        <div><h5>{{price($element->amount)}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Date&Time</h5></div>
                        <div><h5>{{$element->created_at}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Deposit Status</h5></div>
                        <div><h5>
                                @if($element->status == 'rejected')
                                    Failed
                                @elseif($element->status == 'approved')
                                    Success
                                @else
                                    Process
                                @endif
                            </h5></div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="tab-pane" id="2b">
            @foreach(\App\Models\Withdrawal::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
                <div class="history_list" style="border: 1px solid #12fff8;">
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>OID-S.N</h5></div>
                        <div><h5>{{$element->oid}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Withdrawal</h5></div>
                        <div><h5>{{price($element->amount)}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Withdrawal charge</h5></div>
                        <div><h5>{{price($element->charge)}}/{{setting('withdraw_charge')}}%</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Actual Amount</h5></div>
                        <div><h5>{{price($element->final_amount)}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Date&Time</h5></div>
                        <div><h5>{{$element->created_at}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Order Status</h5></div>
                        <div><h5>
                                @if($element->status == 'rejected')
                                    Failed
                                @elseif($element->status == 'approved')
                                    Success
                                @else
                                    Process
                                @endif
                            </h5></div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="tab-pane" id="3b">
            @foreach(\App\Models\UserLedger::where('user_id', user()->id)->where('reason', 'daily_income')->orderByDesc('id')->get() as $element)
                <div class="history_list" style="border: 1px solid #12b888;">
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>My Income</h5></div>
                        <div><h5>{{price($element->amount)}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Date&Time</h5></div>
                        <div><h5>{{$element->created_at}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Perticulation</h5></div>
                        <div><h5>{{$element->perticulation}}</h5></div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="tab-pane" id="4b">
            @foreach(\App\Models\UserLedger::where('user_id', user()->id)->where('reason', 'reward')->orderByDesc('id')->get() as $element)
                <div class="history_list" style="border: 1px solid #12b888;">
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>My Income</h5></div>
                        <div><h5>{{price($element->amount)}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Date&Time</h5></div>
                        <div><h5>{{$element->created_at}}</h5></div>
                    </div>
                    <div style="display: flex;justify-content: space-between;align-items: center;">
                        <div><h5>Perticulation</h5></div>
                        <div><h5>{{$element->perticulation}}</h5></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>


<!-- Bootstrap core JavaScript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
</body>
</html>
